// By EVOLVED
// www.evolved-software.com

//--------------
// tweaks
//--------------
   float2 ViewSize;
   float2 ElapsedTime={0.05,0.25};

//--------------
// Textures
//--------------
   texture LuminanceTexture <string Name = " ";>;
   sampler LuminanceSampler=sampler_state 
      {
	Texture=<LuminanceTexture>;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
     };
   struct OutPut
     {
	float4 Pos:POSITION; 
 	float4 Tex:TEXCOORD0;
	float4 Tex1:TEXCOORD1;
	float4 Tex2:TEXCOORD2;
	float4 Tex3:TEXCOORD3;
	float4 Tex4:TEXCOORD4;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.Pos=IN.Pos; 
 	OUT.Tex.xy=((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewSize;
	OUT.Tex.zw=0.0;
	OUT.Tex1.xy=OUT.Tex+float2(-ViewSize.x,0)*2.0;
	OUT.Tex1.zw=OUT.Tex+float2(ViewSize.x,0)*2.0;
	OUT.Tex2.xy=OUT.Tex+float2(0,-ViewSize.y)*2.0;
	OUT.Tex2.zw=OUT.Tex+float2(0,ViewSize.y)*2.0;
	OUT.Tex3.xy=OUT.Tex+float2(-ViewSize.x,-ViewSize.y)*2.0;
	OUT.Tex3.zw=OUT.Tex+float2(ViewSize.x,ViewSize.y)*2.0;
	OUT.Tex4.xy=OUT.Tex+float2(ViewSize.x,-ViewSize.y)*2.0;
	OUT.Tex4.zw=OUT.Tex+float2(-ViewSize.x,ViewSize.y)*2.0;
	return OUT;
    }

//--------------
// pixel shader
//--------------
  float4 PS(OutPut IN) : COLOR
     {
	float2 LuminanceSum=tex2Dlod(LuminanceSampler,IN.Tex)
	                   +tex2Dlod(LuminanceSampler,IN.Tex1.xyyy)
	                   +tex2Dlod(LuminanceSampler,IN.Tex1.zwww)
	                   +tex2Dlod(LuminanceSampler,IN.Tex2.xyyy)
	                   +tex2Dlod(LuminanceSampler,IN.Tex2.zwww)
	                   +tex2Dlod(LuminanceSampler,IN.Tex3.xyyy)
	                   +tex2Dlod(LuminanceSampler,IN.Tex3.zwww)
	                   +tex2Dlod(LuminanceSampler,IN.Tex4.xyyy)
	                   +tex2Dlod(LuminanceSampler,IN.Tex4.zwww);
  	float2 AdaptedLuminance=tex2Dlod(LuminanceSampler,IN.Tex).zw;
 	float2 Adaptation=AdaptedLuminance+(exp(LuminanceSum*0.111111)-AdaptedLuminance)*(1-pow(0.98,30*ElapsedTime));
	return float4(Adaptation,0.0,0.0);	
     }  

//--------------
// techniques   
//--------------
    technique AdaptedLuminance
      {
 	pass p1
      {	
 	VertexShader = compile vs_3_0 VS();
 	PixelShader  = compile ps_3_0 PS();
	zwriteenable=false;
	zenable=false;
	ZFunc=always;
      }
      }
